*** Tables for Ansell & Samuels (2014) Chapter Five

*** Please use "Ansell Samuels Chapters Five and Six.dta"

*** Code includes esttab commands to produce tables, information available at http://repec.org/bocode/e/estout/esttab.html



*** Table for Basic Probit Analysis of Binary Democracy and BM Gini (Table 5.1)

probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp   year yearsq , r
eststo m1
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp    year yearsq , cluster(bmcode)
eststo m2
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk    year yearsq , r
eststo m3
probit democracy lagdemocracy  lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk    year yearsq , cluster(bmcode)
eststo m4
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk  LagRuralInequality LagDemXLagRuralInequality  year yearsq , r
eststo m5
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk  LagRuralInequality LagDemXLagRuralInequality  year yearsq , cluster(bmcode)
eststo m6


esttab m1 m2 m3 m4 m5 m6 using "table1.tex", label  star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) eqlabels(, none) drop(year yearsq) booktabs replace frag  compress nomtitles nodepvars title("Binary Analysis of Democracy Variable"\label{tab1}) addnotes("Models 1. 3. 5 have robust standard errors. Models 2, 4, 6 use clustered standard errors")



*** Conditional Logit Analysis of Binary Democracy and BM Gini (Table 3.3)

cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
LagVHknow LagDemXLagVHk year yearsq
eststo m1
cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
 LagVHknow LagDemXLagVHk i.year
eststo m2
cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
LagVHknow LagDemXLagVHk year yearsq bm1-bm27
eststo m3
cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
LagVHknow LagDemXLagVHk i.year bm1-bm27
eststo m4

cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
LagVHknow LagDemXLagVHk year yearsq c1-c180
eststo m5
cloglog democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginii ldemlbmgdp LagRuralInequality LagDemXLagRuralInequality ///
LagVHknow LagDemXLagVHk i.year c1-c187
eststo m6

esttab m1 m2 m3 m4 m5 m6  using "cloglogbm.tex", eqlabels(, none) label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
drop(year yearsq  ****.year bm* bm** c* c** c*** o.c*** o.bm****) booktabs replace frag  compress nomtitles nodepvars


*** Testing the Quadratic Functional For Binary Democracy and BM Gini (Table 5.4)

probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk ///
LagRuralInequality LagDemXLagRuralInequality  year yearsq , cluster(bmcode)
eststo m1
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk ///
LagRuralInequality LagDemXLagRuralInequality lbmginiintsq ldemlbmginisq year yearsq , cluster(bmcode)
eststo m2
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk ///
LagRuralInequality LagDemXLagRuralInequality LagRuralIneqSq LagDemXLagRuralIneqSq  year yearsq , cluster(bmcode)
eststo m3
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk ///
LagRuralInequality LagDemXLagRuralInequality lbmginiintsq ldemlbmginisq LagRuralIneqSq LagDemXLagRuralIneqSq  year yearsq , cluster(bmcode)
eststo m4

esttab m1 m2 m3 m4 using "bmbinarysq.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
drop(year yearsq) booktabs replace frag eqlabels(,none) compress nomtitles nodepvars aic bic 





*** Babones Alvarez_Rivadulla w. PWT (Table 5.5)



probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT  ///
 y155-y205 regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11, r
eststo m1 
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality ///
LagDemXLagRuralInequality LagVHknowledgeINT LagDemXLagVHknowlInt    y155-y205 regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11  , r
eststo m2
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT  oilexp LagDemXoil ///
islam50 LagDemXislam50 lcwarten LagDemXlcwarten c.lagdemocracy##c.l.pwt_openk c.lagdemocracy##c.l.pwt_logpo  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11, r
eststo m3
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality ///
 LagDemXLagRuralInequality LagVHknowledgeINT LagDemXLagVHknowlInt  oilexp LagDemXoil islam50 LagDemXislam50 lcwarten LagDemXlcwarten c.lagdemocracy##c.l.pwt_openk c.lagdemocracy##c.l.pwt_logpo  ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11, r
   eststo m4
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality ///
 LagDemXLagRuralInequality LagVHknowledgeINT LagDemXLagVHknowlInt  oilexp LagDemXoil islam50 LagDemXislam50 lcwarten LagDemXlcwarten c.lagdemocracy##c.l.pwt_openk c.lagdemocracy##c.l.pwt_logpo  ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 if year<=1980, r
eststo m5
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality ///
LagDemXLagRuralInequality LagVHknowledgeINT LagDemXLagVHknowlInt  oilexp LagDemXoil islam50 LagDemXislam50 lcwarten LagDemXlcwarten c.lagdemocracy##c.l.pwt_openk c.lagdemocracy##c.l.pwt_logpo ///
 year   regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  if year>1980, r
eststo m6
esttab m1 m2 m3 m4 m5 m6 using "babbinary_pwt.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) frag ///
drop(y*** regc** o.y*** o.lagdemocracy o.LagDemXoil) booktabs replace nogaps compress nomtitles nodepvars eqlabels(,none) coeflabels (L.pwt_openk "Openness" L.pwt_logpop "Log Population" ///
c.lagdemocracy#cL.pwt_openk "Lag Dem X Openness" c.lagdemocracy#cL.pwt_logpop "Lag Dem X Pop.")


** Polity models: BM Data 1820-1990 (Table 5.6)

xtreg polity2 lagpolity lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq if sovereign==1, fe 
eststo m1
xtreg polity2 lagpolity lbmginiint lbmgdppint LagRuralInequality LagVHknow y1-y205 if sovereign==1, fe 
eststo m2
xtregar polity2  lbmginiint lbmgdppint LagRuralInequality LagVHknow if sovereign==1, fe 
eststo m3
xtpcse polity2 lagpolity lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq  if sovereign ==1, correlation (psar1) pairwise
eststo m4
xtpcse polity2 lagpolity lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq bm1-bm27 if sovereign ==1, correlation (psar1) pairwise
eststo m5
xtpcse polity2 lagpolity lbmginiint lbmgdppint LagRuralInequality LagVHknow y1-y205 bm1-bm27 if sovereign ==1, correlation (psar1) pairwise  independent 
eststo m6

esttab m1 m2 m3 m4 m5 m6 using "bmpolity.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
drop(y*** bm** o.y*** o.bm*** o._cons) booktabs replace frag  compress nomtitles nodepvars 



*** Babones Alvarez_Rivadulla Tables Polity (Table 5.7)


xtreg  polity2 lagpolity Lagsbginiext  l.pwt_rgdpch  year , fe cluster(ccode)
eststo m1
xtreg  polity2 lagpolity Lagsbginiext  l.pwt_rgdpch  LagRuralInequality  l.pwt_openk l.pwt_logpop year , fe cluster(ccode)
eststo m2
xtregar  polity2 lagpolity Lagsbginiext  l.pwt_rgdpch  LagRuralInequality  l.pwt_openk l.pwt_logpop  , fe 
eststo m3
xtpcse  polity2 lagpolity Lagsbginiext l.pwt_rgdpch  ///
 year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , correlation(ar1) pairwise
eststo m4
xtpcse  polity2 lagpolity Lagsbginiext l.pwt_rgdpch  LagRuralInequality l.pwt_openk l.pwt_logpop ///
 year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , correlation(ar1) pairwise
eststo m5
xtpcse  polity2 lagpolity Lagsbginiext l.pwt_rgdpch   LagRuralInequality l.pwt_openk l.pwt_logpop oilexp islam50 lcwarten ///
 year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , correlation(ar1) pairwise
eststo m6

esttab m1 m2 m3 m4  m5 m6 using "barpolity_pwt.tex", label star (* 0.10 ** 0.05 *** 0.0102) b(%12.3f) se(%12.3f) ///
drop(y*** regc**) booktabs replace frag  compress nomtitles nodepvars  coeflabels(L.pwt_openk "Openness" L.pwt_rgdpch "GDP per capita" L.pwt_logpop "Log Population")

s replace frag  compress nomtitles nodepvars aic bic coeflabels(L.pwt_openk "Openness" L.pwt_rgdpch "GDP per capita" L.pwt_logpop "Log Population")



***  Instrumental Variables Test for BM Gini (Table 5.8)

reg lbmginiint l20bmgini lbmgdppint LagRuralInequality  LagVHknowledgeINT year yearsq
 predict fittedprob
 gen LagDemXfittedpbar = lagdemocracy*fittedprob
 probit democracy fittedprob lbmgdppint LagDemXfittedpbar ldemlbmgdp LagVHknow LagDemXLagVHk  ///
LagRuralInequality LagDemXLagRuralInequality lagdemocracy  year yearsq , r
drop fittedprob LagDemXfittedpbar 
  eststo m1
  
reg lbmginiint regionlbmgini lbmgdppint  LagRuralInequality  LagVHknowledgeINT year yearsq
 predict fittedprob
  gen LagDemXfittedpbar = lagdemocracy*fittedprob
 probit democracy fittedprob lbmgdppint LagDemXfittedpbar ldemlbmgdp LagVHknow LagDemXLagVHk  ///
LagRuralInequality LagDemXLagRuralInequality lagdemocracy  year yearsq , r
drop fittedprob LagDemXfittedpbar
eststo m2
xtivreg polity2 lagpolity (lbmginiint = l20bmgini) lbmgdppint LagRuralInequality LagVHknow year yearsq, fe 
eststo m3
xtivreg polity2 lagpolity (lbmginiint = regionlbmgini) lbmgdppint LagRuralInequality LagVHknow year yearsq, fe 
eststo m4

reg lbmginiint l20bmgini LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT year yearsq
predict fittedbm
xtpcse polity2 lagpolity fittedbm lbmgdppint LagRuralInequality LagVHknow year yearsq bm1-bm27 if sovereign ==1, correlation (psar1) pairwise
drop fittedbm
eststo m5
reg lbmginiint regionlbmgini LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT year yearsq
predict fittedbm
xtpcse polity2 lagpolity fittedbm lbmgdppint LagRuralInequality LagVHknow year yearsq bm1-bm27 if sovereign ==1, correlation (psar1) pairwise
drop fittedbm
eststo m6

esttab m1 m2 m3 m4 m5 m6 using "bmiv.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) rename (fittedprob lbmginiint fittedbm lbmginiint) ///
drop(y*** yearsq bm** o.bm*** o._cons) booktabs replace frag  compress nomtitles nodepvars eqlabels(, none) coeflabels(fittedprob "BM Gini" LagDemXfittedpbar  "Lag Dem X BM Gini")

*** Instrumental Variables Test for BAR Gini (Table 5.9)


* Instrumental Variables Test for BAR Gini PWT

reg Lagsbginiext L5sbgini lagdemocracy l.pwt_rgdpch LagRuralInequality  l.pwt_openk l.pwt_logpop oilexp islam50 lcwarten year 
predict fittedpbar
gen LagDemXfittedpbar = lagdemocracy*fittedpbar
probit democracy lagdemocracy fittedpbar LagDemXfittedpbar c.lagdemocracy##c.l.pwt_rgdpch LagRuralInequality ///
 LagDemXLagRuralInequality c.lagdemocracy##c.l.pwt_openk c.lagdemocracy##c.l.pwt_logpop oilexp LagDemXoil islam50 LagDemXislam50 lcwarten LagDemXlcwarten ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11, r
drop fittedpbar LagDemXfittedpbar
eststo m1

reg Lagsbginiext regionlsbgini lagdemocracy LagMadgdpcapINT LagRuralInequality LagVHknowledgeINT oilexp islam50 lcwarten year 
predict fittedpbar
gen LagDemXfittedpbar = lagdemocracy*fittedpbar
probit democracy lagdemocracy fittedpbar LagDemXfittedpbar LagMadgdpcapINT LagDemXLagMadgdpcapINT c.lagdemocracy#c.l.pwt_openk LagRuralInequality ///
 LagDemXLagRuralInequality LagVHknowledgeINT LagDemXLagVHknowlInt  oilexp LagDemXoil islam50 LagDemXislam50 lcwarten LagDemXlcwarten ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11, r
drop fittedpbar LagDemXfittedpbar
eststo m2

xtivreg  polity2 lagpolity (Lagsbginiext=L5sbgini) LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT year if sovereign==1 , fe 
eststo m3

xtivreg  polity2 lagpolity (Lagsbginiext=regionlsbgini) LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT year if sovereign==1 , fe
eststo m4

drop fittedsb
reg Lagsbginiext L5sbgini LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50 lcwarten year
predict fittedsb
xtpcse  polity2 lagpolity fittedsb LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50 lcwarten year ///
regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , correlation(ar1) pairwise

eststo m5
drop fittedsb
reg Lagsbginiext regionlsbgini LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50 lcwarten year
predict fittedsb
xtpcse  polity2 lagpolity fittedsb LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50 lcwarten year ///
regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , correlation(ar1) pairwise
eststo m6

esttab m1 m2 m3 m4 m5 m6 using "bariv.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
drop(y*** regc*  ) booktabs replace frag  compress nomtitles nodepvars 

